<?php

namespace App\Http\Controllers;

use App\User;
use App\Comment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('show');
    }

    public function show(User $user)
    {
        $ratecount = Comment::where('user_id', $user->id)->count();

        // if (is_float($user->links->star)) {
        //     $displaystars = round($user->links->star);
        //     if ($displaystars < $user->links->star) {
        //         $displaystars++;
        //     } else {
        //         $displaystars;
        //     }
            
        // } else {
        //     $displaystars = $user->links->star;
        // }

        return view('links.profile', compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {
        $user = Auth::user();
        return view('links.edit_user', compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        $this->validate(request(), [
            'email' => ['required', Rule::unique('users')->ignore($user->id),],
            'password' => 'sometimes|min:6|confirmed'
        ]);

        
        $user->email = request('email');
        $user->password = bcrypt(request('password'));
        if($request->has('password')) {
	        $user->password = bcrypt(request('password'));
	}

        $user->save();
        return redirect()->back()->withMessage('Your personal data is successfully edited!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        $user->delete();
        return redirect()->back()->withMessage('User has been successfully deleted!');
    }
}
