<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Link;
use App\Category;

class WelcomeController extends Controller
{
    public function welcome()
    {
        $links = Link::whereNotNull('star')->orderBy('created_at', 'desc')->paginate(8);
        $categories = Category::take(4)->get();

        // Rendering stars and half star rating
        // if (is_float($link->star)) {
        //     $displaystars = round($link->star);
        // } else {
        //     $displaystars = $link->star;
        // }

        return view('welcome', compact('links', 'categories'));
    }

    public function sitemap(Request $r)
    {
        $posts = Link::orderBy('id','desc')->get();
        return response()->view('sitemap', compact('posts'))->header('Content-Type', 'text/xml');
    }
}
