<?php

namespace App\Providers;

use App\AdminSet;
use App\Page;
use App\Category;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(119);

        view::composer(['layouts.app', 'home', 'welcome', 'links.search', 'links.category', 'links.single', 'links.profile'], function($view){
            $view->with('admin', AdminSet::all()->first());
        });

        view::composer(['layouts.app'], function($view){
            $view->with('pages', Page::where('visibility', 'yes')->get());
        });

    }
}
