@extends('admin.layouts.adminmaster')

@section('title', 'Admin Management')
@section('head', 'Admin Management')

@section('content')
  <div class="container">
    @include('partials.msg')
    @include('partials.errormsg')
    <div class="row mb-4">
        <div class="col-md-12">
            <h2>Admins</h2>
            <div class="alert alert-dismissible bg-dark text-secondary p-4 my-2">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                This page is only visible to you as the owner of the site.<br> Here you manage the admins of your site, who can "edit" & "delete" the posts.
            </div>
            <table class="table table-hover">
                <thead class="bg-warning">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Posts</th>
                        <th>Actions</th>
                        <th>Moderate user</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $user)
                    <tr>
                        <td>{{ $loop->index + 1 }}</td>
                        <td>{{ $user->name }}</td>
                        <td><span class="badge-pill badge-warning">{{ $user->links()->count() }}</span></td>
                        <td>
                            <!-- Edit & delete button -->
                            <div class="float-left">
                                <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modal{{$user->id}}">
                                    See
                                </button>
                                    <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#delete{{$user->id}}">
                                        Delete
                                    </button>
                            </div>
                            
                            @include('admin.partials.see_user')
                            @include('admin.partials.delete_user')
                        </td>
                        
                        <td>
                            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#edit{{$user->id}}">
                                Assign
                            </button>
                            @include('admin.partials.edit_user')
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {{ $users->links() }}
        </div>
        
    </div>
  </div>
@endsection