<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- CSRF Token -->
  <meta name="csrf-token" content="{{ csrf_token() }}">

  <title>{{ config('app.name', 'LinkDir') }} | @yield('title')</title>

  <!-- Favicon icon -->
  <link rel="icon" type="image/png" sizes="16x16" href="{{asset('/images/linkdir/favicon.png')}}">

  <!-- Font Awesome -->
  <link href="{{ asset('css/admin/font-awesome.min.css') }}" rel="stylesheet">

  <!-- Styles -->
  <link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet">

  <!-- Custom styles for this template -->
  <link href="{{ asset('css/admin/sidebarstyle.css') }}" rel="stylesheet">

</head>

<body>

  <div class="d-flex" id="wrapper">

    <!-- Sidebar -->
    <div class="bg-dark text-light border-right" id="sidebar-wrapper">
      <div class="sidebar-heading"><i class="fa fa-paw"></i> LinkDir!</div>
      <div class="list-group list-group-flush">
        <a class="list-group-item list-group-item-action bg-dark d-flex justify-content-between align-items-center text-light {{ Request::is('admin_set/panel') ? 'active' : '' }}" href="{{ route('adminpanel') }}">
          Admin Panel <span class="fa fa-trophy"></span>
        </a>
        <a class="list-group-item list-group-item-action bg-dark d-flex justify-content-between align-items-center text-light {{ Request::is('admin_set/pages') ? 'active' : '' }}" href="{{ route('adminpages') }}">
          Page <span class="fa fa-file-text"></span>
        </a>
        <a class="list-group-item list-group-item-action bg-dark d-flex justify-content-between align-items-center text-light {{ Request::is('admin_set/category') ? 'active' : '' }}" href="{{ route('adcate') }}">
          Category <span class="fa fa-cubes"></span>
        </a>
        <a class="list-group-item list-group-item-action bg-dark d-flex justify-content-between align-items-center text-light {{ Request::is('admin_set/users') ? 'active' : '' }}" href="{{ route('adusers') }}">
          Users <span class="fa fa-users"></span>
        </a>        
        <a class="list-group-item list-group-item-action bg-dark d-flex justify-content-between align-items-center text-light {{ Request::is('admin_set/sites') ? 'active' : '' }}" href="{{ route('adsites') }}">
          Posts <span class="fa fa-desktop"></span>
        </a>
        <a class="list-group-item list-group-item-action bg-dark d-flex justify-content-between align-items-center text-light {{ Request::is('admin_set/settings') ? 'active' : '' }}" href="{{ route('adsettings') }}">
          Settings <span class="fa fa-gear"></span>
        </a>
        <a class="list-group-item list-group-item-action bg-dark d-flex justify-content-between align-items-center text-light {{ Request::is('admin_set/ads') ? 'active' : '' }}" href="{{ route('ads') }}">
          Advertisements <span class="fa fa-money"></span>
        </a>
        
        <a href="{{ route('support') }}" class="btn btn-success w-50 mt-5 mx-auto">Support</a>
      </div>
    </div>
    <!-- /#sidebar-wrapper -->

    <!-- Page Content -->
    <div id="page-content-wrapper">

      <nav class="navbar navbar-expand-lg navbar-dark bg-primary border-bottom">
        <button class="btn btn-primary" id="menu-toggle"><i class="fa fa-arrows-h fa-2x"></i></button>

        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <ul class="navbar-nav ml-auto mt-2 mt-lg-0">
            <li class="nav-item active">
              <a class="nav-link" href="{{ route('main') }}" target="_blank"><i class="fa fa-home"></i> Home <span class="sr-only">(current)</span></a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="{{ route('home') }}" target="_blank"><i class="fa fa-dashboard"></i> Dashboard</a>
            </li>
            
          </ul>
        </div>
      </nav>

      <div class="container-fluid">
        <h3 class="mt-4 text-success"><i class="fa fa-graduation-cap"></i> Administrator <span class="text-muted"><i class="fa fa-at"></i> @yield('head')</span></h3>
        @yield('content')
      </div>

      <div class="fixed-bottom bg-dark text-light text-right pr-4">
        <small>
          <strong>LinkDir (v-2.1.2)</strong>
          Made with <i class="fa fa-heart text-danger"></i> by <a class="text-muted" href="https://webfuelcode.wall-spot.com" target="_blank">Wall-Spot</a> (Distributed - WebFuelCode)
        </small>
      </div>
    </div>
    <!-- /#page-content-wrapper -->

  </div>
  <!-- /#wrapper -->

  <!-- Bootstrap core JavaScript -->
  <script src="{{asset('js/admin/jquery.min.js')}}"></script>
  <script src="{{asset('js/admin/bootstrap.bundle.min.js')}}"></script>

  <!-- Menu Toggle Script -->
  <script>
    $("#menu-toggle").click(function(e) {
      e.preventDefault();
      $("#wrapper").toggleClass("toggled");
    });
  </script>

</body>

</html>
