@extends('admin.layouts.adminmaster')

@section('title', 'Page Management')
@section('head', 'Page Management')

@section('content')
  <div class="container">
    @include('partials.msg')
    @include('partials.errormsg')
    <div class="row">
        <div class="col-md-9">
            <h2>Pages</h2>
            <table class="table table-hover">
                <thead class="bg-warning">
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Visible in footer</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($pages as $page)
                    <tr>
                        <td><p>{{ $loop->index + 1 }}</p></td>
                        <td><p>{{ $page->title }}</p></td>
                        <td><p>{{ $page->visibility }}</p></td>
                        <td>
                            <!-- Edit & delete button -->
                            <div class="float-left">
                                <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modal{{$page->id}}">
                                    Edit
                                </button>

                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#delete{{$page->id}}">
                                    Delete
                                </button>
                            </div>
                            
                            @include('admin.partials.edit_page')
                            @include('admin.partials.delete_page')
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {{ $pages->links() }}
        </div>
        
        <div class="col-md-3">
            
            <div class="card border-info my-2">
                <div class="card-header">
                    Admin operation
                </div>
                <div class="card-body">
                    
                    <div class="card-link">
                      <a class="btn btn-outline-info btn-lg btn-block" href="#" data-toggle="modal" data-target="#modaladd">Add new post</a>
            
                      @include('admin.partials.add_page')
                    </div>
                </div>
              </div>

        </div>
    </div>
  </div>
@endsection