@extends('admin.layouts.adminmaster')

@section('title', 'Post Management')
@section('head', 'Post Management')

@section('content')
  <div class="container">
    @include('partials.msg')
    @include('partials.errormsg')
    <div class="row mb-4">
        <div class="col-md-9">
            <h2>Posts</h2>
            <table class="table table-hover">
                <thead class="bg-warning">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Details</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>                    
                    @forelse ($links as $link)
                    <tr>
                        <td><p>{{ $loop->index + 1 }}</p></td>
                        <td><p>{{ $link->title }}</p></td>
                        <td>
                            <p>in
                                <span>
                                    <a class="text-warning" href="{{route('category.show', $link->category->slug)}}" target="_blank" rel="noopener noreferrer">{{ $link->category->name ?? 'No category' }}</a>
                                </span>
                                <em>by</em>
                                <span class="text-success">
                                    <em>{{ $link->user->name }}</em>
                                </span>
                            </p>
                        </td>
                        <td>
                            <!-- Edit & delete button -->
                            <div class="float-left">
                                <a class="btn btn-success btn-sm" href="{{route('link.show', $link->slug)}}" target="_blank" rel="noopener noreferrer">Show</a>
                                <button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#modal{{$link->id}}">
                                    Edit
                                </button>

                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete{{$link->id}}">
                                    Delete
                                </button>
                            </div>
                            
                            @include('admin.partials.edit_site')
                            @include('admin.partials.delete_site')
                        </td>
                    </tr>
                    @empty
                    No records are here.
                    @endforelse
                </tbody>
            </table>
            {{ $links->links() }}
        </div>
        
        <div class="col-md-3">
            
            <div class="card border-info my-2">
                <div class="card-header">
                    Site operation
                </div>
                <div class="card-body">
                    
                    <div class="card-link">
                      <a class="btn btn-outline-info btn-lg btn-block" href="#" data-toggle="modal" data-target="#modaladd">Add new post</a>
            
                      @include('admin.partials.add_site')
                    </div>
                </div>
              </div>

        </div>
    </div>
  </div>
@endsection