<div class="card border-0 bg-light mt-2">
    <div class="card-body row">
        <div class="col-md-3">
            @if ($item->icon)
                <img src="{{asset('images/icon')}}/{{$item->icon}}" alt="" class="img-fluid">
            @else
                <img src="{{asset('images/linkdir')}}/default/icon.png" alt="" class="img-fluid rounded">
            @endif
        </div>
        <div class="col-md-9">
            <h5 class="card-title d-flex justify-content-between">
                <div>
                    <a href="{{route('link.show', $item->slug)}}">{{$item->title}}</a>
                </div>
                <div>
                    @for ($i = 0; $i < 5; $i++)
                        @if (round($item->star) > $i)
                            
                            @if (is_float($item->star) && round($item->star) == $i+1 && round($item->star) > $item->star)
                                <i class="fa fa-star-half-o text-warning"></i>
                            @else
                                <i class="fa fa-star text-warning"></i>
                            @endif
                        @else
                            <i class="fa fa-star"></i>
                        @endif
                    @endfor
                </div>
            </h5>
            <div>
                {!! Str::words($item->description, '12', '...') !!}
            </div>
            <div>
                <small>
                    Category: <a href="{{route('category.show', $item->category->slug)}}">{{$item->category->name}}</a>
                </small>
            </div>
        </div>
    </div>
</div>