<div class="card my-3">
  <div class="card-header d-flex justify-content-between">
    <div>
      @for ($i = 0; $i < 5; $i++)
          @if ($displaystars > $i)
            
              @if (is_float($link->star) && $displaystars == $i+1 && $displaystars > $link->star)
                  <i class="fa fa-star-half-o text-warning"></i>
              @else
                  <i class="fa fa-star text-warning"></i>
              @endif
          @else
              <i class="fa fa-star"></i>
          @endif
      @endfor
      {{$link->star}}
      (Based on {{$ratecount}} ratings)
    </div>

    @auth
      @if ($rated)
        <a href="#" data-toggle="modal" data-target="#editcm{{$rated->id}}">Edit review</a>
        @include('links.modal.comment_editrated')
      @else
        <a href="#" data-toggle="modal" data-target="#postcm">Post review</a>
      @endif
      @include('links.modal.comment_post')
    @endauth
  </div>
  <div class="card-body">
    <div class="row">
      <div class="col-md-3">
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
      </div>
      <div class="col-md-7">
        <div class="progress my-2">
          <div class="progress-bar bg-success" role="progressbar" aria-valuenow="{{$s5}}" aria-valuemin="0" aria-valuemax="100" style="width: {{$s5}}%"></div>
        </div>
      </div>
      <div class="col-md-2">
        {{$c5}} vote
      </div>
    </div>
    <div class="row">
      <div class="col-md-3">
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star"></i>
      </div>
      <div class="col-md-7">
        <div class="progress my-2">
          <div class="progress-bar bg-success" role="progressbar" aria-valuenow="{{$s4}}" aria-valuemin="0" aria-valuemax="100" style="width: {{$s4}}%"></div>
        </div>
      </div>
      <div class="col-md-2">
        {{$c4}} vote
      </div>
    </div>
    <div class="row">
      <div class="col-md-3">
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star"></i>
        <i class="fa fa-star"></i>
      </div>
      <div class="col-md-7">
        <div class="progress my-2">
          <div class="progress-bar" role="progressbar" aria-valuenow="{{$s3}}" aria-valuemin="0" aria-valuemax="100" style="width: {{$s3}}%"></div>
        </div>
      </div>
      <div class="col-md-2">
        {{$c3}} vote
      </div>
    </div>
    <div class="row">
      <div class="col-md-3">
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star"></i>
        <i class="fa fa-star"></i>
        <i class="fa fa-star"></i>
      </div>
      <div class="col-md-7">
        <div class="progress my-2">
          <div class="progress-bar bg-danger" role="progressbar" aria-valuenow="{{$s2}}" aria-valuemin="0" aria-valuemax="100" style="width: {{$s2}}%"></div>
        </div>
      </div>
      <div class="col-md-2">
        {{$c2}} vote
      </div>
    </div>
    <div class="row">
      <div class="col-md-3">
        <i class="fa fa-star text-warning"></i>
        <i class="fa fa-star"></i>
        <i class="fa fa-star"></i>
        <i class="fa fa-star"></i>
        <i class="fa fa-star"></i>
      </div>
      <div class="col-md-7">
        <div class="progress my-2">
          <div class="progress-bar bg-danger" role="progressbar" aria-valuenow="{{$s1}}" aria-valuemin="0" aria-valuemax="100" style="width: {{$s1}}%"></div>
        </div>
      </div>
      <div class="col-md-2">
        {{$c1}} vote
      </div>
    </div>
  </div>
</div>

<div class="card">
  <h6 class="card-header bg-info text-white">
    Member's review
  </h6>

  @forelse ($comments as $comment)
  <div class="card bg-light {{$loop->last ? '' : 'mb-1'}} border-0">
    <div class="card-body">
      <div class="row">
        <div class="col-md-3">
            <div>
              <a href="{{route('users.show', $comment->user->name)}}">{{$comment->user->name}}</a>
            </div>
            {{-- @for ($i = 0; $i < 5; $i++)
                @if ($i < $comment->stars)
                    <span class="fa fa-star text-warning"></span>
                @else
                    <span class="fa fa-star"></span>
                @endif
            @endfor --}}

            @for ($i = 0; $i < 5; $i++)
            @if (round($comment->stars) > $i)
              
                @if (is_float($comment->stars) && round($comment->stars) == $i+1)
                    <i class="fa fa-star-half-o text-warning"></i>
                @else
                    <i class="fa fa-star text-warning"></i>
                @endif
            @else
                <i class="fa fa-star"></i>
            @endif
        @endfor
        </div>
        <div class="col-md-9">
            <div>{{$comment->body}}</div>
            <div class="d-flex align-items-center">
              <small>
                @if ($comment->created_at == $comment->updated_at)
                  <strong>Posted:</strong> {{$comment->created_at->diffForHumans()}}
                @else
                  <strong>Updated:</strong> {{$comment->updated_at->diffForHumans()}}
                @endif
              </small>
              @auth
                @if (Auth::id() == $comment->user_id)
                  <button type="submit" class="btn btn-success btn-sm badge m-1" data-toggle="modal" data-target="#editcm{{$comment->id}}">Edit</button>
                  <button type="submit" class="btn btn-danger btn-sm badge m-1" data-toggle="modal" data-target="#deletecm{{$comment->id}}">Delete</button>

                  @include('links.modal.comment_edit')
                  @include('links.modal.comment_delete')
                @endif
              @endauth
          </div>
        </div>
      </div>
    </div>
  </div>
  @empty
      <div class="text-info p-3">No ratings has recorded yet. Be the first to rate it.</div>
  @endforelse
</div>

<div class="mt-1">
  {{$comments->links()}}
</div>