<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Mail\WelcomeMail;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'WelcomeController@welcome')->name('main');

Auth::routes();

Route::get('sitemap','WelcomeController@sitemap');

Route::get('/home', 'HomeController@index')->name('home');

Route::get('admin_set/panel', 'AdminSetController@admin_panel')->name('adminpanel');
Route::get('admin_set/pages', 'AdminSetController@pages')->name('adminpages');
Route::get('admin_set/users', 'AdminSetController@memlist')->name('adusers');
Route::get('admin_set/admins', 'AdminSetController@adminlist')->name('admins');
Route::get('admin_set/sites', 'AdminSetController@sitelist')->name('adsites');
Route::get('admin_set/category', 'AdminSetController@catelist')->name('adcate');
Route::get('admin_set/settings', 'AdminSetController@settings')->name('adsettings');
Route::get('admin_set/ads', 'AdminSetController@ads')->name('ads');
Route::get('admin_set/support', 'AdminSetController@support')->name('support');

Route::put('admin_set/settings/{adminset}', 'AdminSetController@update_settings')->name('upsettings');
Route::put('admin_set/user/{user}', 'AdminSetController@memup')->name('admemup');
Route::put('admin_set/settings/social/{adminset}', 'AdminSetController@update_social')->name('upsocial');
Route::put('admin_set/ads/{adminset}', 'AdminSetController@update_ads')->name('upads');
Route::put('admin_set/site/{link}', 'AdminSetController@update_site')->name('upsite');

Route::delete('admin_set/site/{link}', 'AdminSetController@delete_site')->name('desite');

Route::post('admin_set/add', 'AdminSetController@addnew')->name('addnew');

Route::resource('users', 'UserController', ['except' => ['index', 'create', 'store']]);

Route::resource('category', 'CategoryController', ['except' => ['create', 'edit']]);

Route::resource('link', 'LinkController');
// Route::post('add-new', 'LinkController@store')->name('link.store');
// Route::get('list', 'LinkController@index')->name('link.index');
// Route::get('list/create', 'LinkController@create')->name('link.create');
// Route::put('list/{link}', 'LinkController@update')->name('link.update');
// Route::get('list-it/{link}', 'LinkController@show')->name('link.show');
// Route::get('list/{link}', 'LinkController@edit')->name('link.edit');
// Route::delete('list/{link}/edit', 'LinkController@destroy')->name('link.destroy');

Route::resource('page', 'PageController', ['except' => ['index', 'create', 'edit']]);

Route::resource('rating', 'StarController');
Route::resource('comment', 'CommentController');

Route::get('search', 'SearchController@search')->name('search');